<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Admin;
use App\Models\Transaction;

class AdminController extends Controller
{
    public function index()
    {   
        $title = "Admin Section" . config('global.site_title');
        $count_users = User::count();
        return view('backend.index', compact('title','count_users'));
    }

    public function users()
    {   
        $user = User::orderBy('created_at', 'desc')->paginate(20);
        $title = "All Users";
        return view('backend.users.users', compact('title', 'user'));
    }

    public function new_user(Request $request, $id = null)
    {   
        $title = "New User  | " . config('global.site_name');

        if ($request->isMethod('GET')) {
            return view('backend.users.new-user', compact('title'));
        }

         if ($request->isMethod('POST')) {

            $request->validate([
                'first_name' => 'required',
                'last_name' => 'required',
                'dob' => 'required',
                'phone' => 'required|numeric|unique:users',
                'email' => 'required|email|unique:users',
                'password' => 'required|min:6',
                'gender' => 'required',
                'acc_type' => 'required',
                'acc_number' => 'required|numeric',
            ]);
            
            $user_id = random_int(11111,99999);
            

            try {
                $user = User::create([
                'first_name'=> $request->input('first_name'),
                'last_name'=> $request->input('last_name'),
                'email'=> $request->input('email'),
                'phone'=> $request->input('phone'),
                'dob'=> $request->input('dob'),
                'gender'=> $request->input('gender'),
                'acc_type'=> $request->input('acc_type'),
                'currency'=> $request->input('currency'),
                'acc_number'=> $request->input('acc_number'),
                'user_id'=> $user_id,
                'user_status'=> "Active",
                'acc_status'=> 1,
                'balance'=> 0,
                'password'=> Hash::make($request->input('password')),
            ]);

            return redirect("admin/new-user")->with('status', ['text'=>'Great, you have successfully registered a New User','type'=>'success']);

            } catch (Throwable $e) {
                
                 return redirect("admin/new-user")->with('status', ['text'=>'Error!, Account could not be created','type'=>'danger']);
            }    

        }
    }

    public function change_status(Request $request, $id)
    {   
        $post = DB::table('users')
            ->where('user_id', $id)
            ->update([
                'user_status'=> $request->input('user_status'),
            ]);
            return redirect("/admin/users")->with('status',['text'=>'User Status Changed','type'=>'success']);
      
    }

    public function getIp(){
        if(!empty($_SERVER['HTTP_CLIENT_IP'])){
            //ip from share internet
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        }elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
            //ip pass from proxy
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        }else{
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }

    public function view_user($user_id)
    {   
        $user = User::where('user_id', $user_id)->first();
        $credit = Transaction::where('trans_type', 'Credit')->where('user_id', $user_id)->get();
        $debit = Transaction::where('trans_type', 'debit')->where('user_id', $user_id)->get();
        $title = "User Details";
        return view('backend.users.view-user', compact('title', 'user','credit','debit'));
    }

    public function new_trans(Request $request, $user_id)
    {   
        $user = User::where('user_id', $user_id)->first();
         if ($request->isMethod('POST')) {
                 $request->validate([
                'trans_type' => 'required',
                'amount' => 'required',
                'dot' => 'required',
                'trans_des' => 'required',

            ]);
            $balance= $user->balance;
            $trans_id = rand(11111,99999);
            $trans_type = $request->trans_type;
            if($trans_type =="Credit"){
                $new_balance = $balance + $request->amount;
            }else{
                $new_balance = $balance - $request->amount;
            }
            

            try {
                Transaction::create([
                'trans_type'=> $request->input('trans_type'),
                'amount'=> $request->input('amount'),
                'dot'=> $request->input('dot'),
                'trans_des'=> $request->input('trans_des'),
                'trans_id'=> $trans_id,
                'user_id'=> $user_id,
                'trans_status'=> "Completed",
            ]);

                DB::table('users')
                    ->where('user_id', $user_id)
                    ->update([
                        'balance'=> $new_balance,
                    ]);

            return redirect('/admin/view-user/'.$user_id)->with('status', ['text'=>'Great, Transaction successfully added','type'=>'success']);

            } catch (Throwable $e) {
                
                 return redirect('/admin/view-user/'.$user_id)->with('status', ['text'=>'Error!, Transaction could not be created','type'=>'danger']);
            }    

        }
    }

    public function delete_trans($trans_id, $user_id) 
    {
        $user = Transaction::where('trans_id', $trans_id)->first();
        $user->delete();

        return redirect('/admin/view-user/'.$user_id)->with('status', ['text'=>'A Transaction was deleted','type'=>'success']);

    }

    public function edit_user(Request $request, $id)
    {   
        $title = "Edit User| " . config('global.site_name');
        $user = User::where('user_id', $id)->first();

        if ($request->isMethod('GET')) {
            return view('backend.users.edit-user', compact('title','user'));
        }

         if ($request->isMethod('POST')) {

            $request->validate([
                'first_name' => 'required',
                'last_name' => 'required',
                'dob' => 'required',
                'phone' => 'required|numeric',
                'email' => 'required|email',
                'gender' => 'required',
                'acc_type' => 'required',
                'acc_number' => 'required',
            ]);
            
            try {

                $user = DB::table('users')
                    ->where('user_id', $id)
                    ->update([
                        'first_name'=> $request->input('first_name'),
                        'last_name'=> $request->input('last_name'),
                        'email'=> $request->input('email'),
                        'phone'=> $request->input('phone'),
                        'dob'=> $request->input('dob'),
                        'gender'=> $request->input('gender'),
                        'acc_type'=> $request->input('acc_type'),
                        'currency'=> $request->input('currency'),
                        'acc_number'=> $request->input('acc_number'),
                    ]);
             
            
            return redirect('/admin/edit-user/'.$id)->with('status', ['text'=>'User profile has been updated','type'=>'success']);

            } catch (Throwable $e) {
                
                 return redirect('/admin/edit-user/'.$id)->with('status', ['text'=>'Sorry! There was an error while updating profile','type'=>'danger']);
            }
        }
    }



    public function delete_user($user_id) 
    {
        $user = User::where('user_id', $user_id)->first();
        $user->delete();

        $trans = Transaction::where('user_id', $user_id)->first();
        if($trans !=null){
          $trans->delete();  
        }

        
        return redirect("admin/users")->with('status', ['text'=>'A user was deleted','type'=>'success']);

    }

    public function update_picture(Request $request, $user_id)
    {   
        $title = "Change Password " . config('global.site_title');
        $user = User::where('user_id', $user_id)->first();

         if ($request->isMethod('POST')) {

            $request->validate([
                'profile_picture' => 'required|image|mimes:jpg,png,jpeg,gif|max:2048',
            ]);

            $image = $request->file('profile_picture');
            $imageName = time().'.'.$image->extension();
            $imageName = str_replace(' ', '-', $imageName);
            $request->file('profile_picture')->move('uploads', $imageName);

             DB::table('users')
                ->where('user_id', $user_id)
                ->update([
                    'profile_picture'=> $imageName,

                ]);
             

            return redirect('/admin/edit-user/'.$user_id)->with('profile_status', ['text'=>'Successfully update profile Picture','type'=>'success']);
        

        }
    }


    public function password(Request $request)
    {   
        $title = "Change Password";
        $admin_id = $request->session()->get('admin_id');
        $user = Admin::where('admin_id', $admin_id)->first();

        
        if ($request->isMethod('GET')) {
            return view('backend.change-password', compact('title'));
        }

         if ($request->isMethod('POST')) {

            $request->validate([
                'old_password' => 'required',
                'password' => 'required|min:6|confirmed',
            ]);

            $password = $request->old_password;


            if (md5($password) == $user->password) {
             DB::table('admins')
                ->where('admin_id', $admin_id)
                ->update([
                    'password'=> md5($request->input('password')),

                ]);
             
            $request->session()->forget('admin_id');
            return redirect("admin/login")->with('status', ['text'=>'Password has been updated','type'=>'success']);
        }else{

            return redirect("admin/change-password")->with('status', ['text'=>'Sorry! Password does not match','type'=>'danger']);
        }

        }
    }
}
