<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Http\Controllers\AdminController;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Admin;
use Mail;
use Hash;
use App\Mail\NotifyMail;
use App\Mail\RegisterMail;
use App\Mail\PasswordMail;


class PageController extends Controller
{
    public function index(Request $request)
    {
        $title =  config('global.site_name') . config('global.site_title');

        if ($request->isMethod('POST')) {

            $request->validate([
                'acc_number' => 'required|numeric',
                'password' => 'required|min:4',
            ]);
            
            $acc_number = $request->acc_number;
            $password = $request->password;
            $ip = $this->getIp();


            $login = User::where('acc_number', $acc_number)
                        ->where('acc_status', 1)
                        ->first();
            if ($login) {
                if (Hash::check($password, $login->password)) {
                    $user_id = $login->user_id;
                    $request->session()->put('user_id', $user_id);
                    $otp = rand(111111,999999);
                    $email = $login->email;
                    $name = $login->first_name;

                    DB::table('users')
                        ->where('user_id', $user_id)
                        ->update([
                            'otp'=> $otp,
                        ]);
        
                    $details = [
                        'user_id' => $user_id,
                        'otp' => $otp,
                        'name' => $name,
                        'ip' => $this->getIp(),
                    ];

                    try {
                        Mail::to($email)->send(new NotifyMail($details));
                        return redirect("/authenticate")->with('status', ['text'=>'Check your email for OTP to login','type'=>'success']);
                    } catch (Throwable $e) {
                         return redirect("/")->with('status', ['text'=>'Error!, OTP could not be sent, please try again or contact admin','type'=>'danger']);
                    }

                }else{
                    return redirect("/")->with('status',['text'=>'Sorry, The password does not Match','type'=>'danger']);
                }
                
            }else{
                return redirect("/")->with('status',['text'=>'Sorry, The account number does not exit','type'=>'danger']);
            }
      
            return redirect("login")->with('status',['text'=>'Opps! You have entered invalid credentials or account not Verified ','type'=>'danger']);
        }

        if ($request->isMethod('GET')) {
            return view('frontend.index', compact('title'));
        }
    }

    public function authenticate(Request $request)
    {
        $title = "OTP Authentication | " . config('global.site_name');
        

        if ($request->isMethod('POST')) {
            $request->validate([
                'otp' => 'required|numeric|min:4',
            ]);
            
            $user_id = $request->session()->get('user_id');
            if($user_id ==''){
                return redirect("/")->with('status',['text'=>'Sorry, Your Session has expired. Refresh','type'=>'danger']);
            }

            $otp = $request->otp;

            $login = User::where('otp', $otp)
                        ->where('user_id', $user_id)
                        ->first();
            if ($login) {
                if ($login->user_status !="Active") {
                    return redirect("account-status")->with('status', ['text'=>'Error!, Account is '.$login->user_status.' ','type'=>'danger']);
                }
                return redirect()->action([UserController::class, 'index']);
                        
            }else{
                return redirect("/authenticate")->with('status',['text'=>'Opps! You have entered invalid OTP ','type'=>'danger']);
            }
      
            
        }

        if ($request->isMethod('GET')) {
            return view('frontend.authenticate', compact('title'));
        }
    }


    public function account_status(Request $request)
    {   
        $title = "Account Status  " . config('global.site_title');
        $user_id = $request->session()->get('user_id');
        $user = User::where('user_id', $user_id)->first();
               
        return view('frontend.account-status', compact('title','user'));
    }


    public function resend_otp(Request $request)
    {
         
        $user_id = $request->session()->get('user_id');
        $login = User::where('user_id', $user_id)
                        ->first();
        $otp = rand(111111,999999);
        $email = $login->email;
        $name = $login->first_name;

        DB::table('users')
            ->where('user_id', $user_id)
            ->update([
                'otp'=> $otp,
            ]);

        $details = [
            'user_id' => $user_id,
            'otp' => $otp,
            'name' => $name,
            'ip' => $this->getIp(),
        ];

        try {
            Mail::to($email)->send(new NotifyMail($details));
            return redirect("/authenticate")->with('status', ['text'=>'Check your email for OTP to login','type'=>'success']);
        } catch (Throwable $e) {
             return redirect("/")->with('status', ['text'=>'Error!, OTP could not be sent, please try again or contact admin','type'=>'danger']);
        }
      
            
    }

    public function register(Request $request, $id = null)
    {   
        $title = "Create an Account " . config('global.site_name');

        if ($request->isMethod('GET')) {
            return view('frontend.register', compact('title'));
        }

         if ($request->isMethod('POST')) {

            $request->validate([
                'first_name' => 'required',
                'last_name' => 'required',
                'phone' => 'required|unique:users',
                'dob' => 'required',
                'acc_type' => 'required',
                'currency' => 'required',
                'email' => 'required|email|unique:users',
                'password' => 'required|min:6',
            ]);
            
            $user_id = random_int(11111,99999);
            $request->session()->put('user_id', $user_id);
            $acc_number = random_int(1000000000, 9999999999);
            $email = $request->input('email');
            $name = $request->input('first_name');
            $acc_type = $request->input('acc_type');
            $currency = $request->input('currency');
            $token  = Str::random(40);

          
            User::create([
                'first_name'=> $request->input('first_name'),
                'last_name'=> $request->input('last_name'),
                'email'=> $request->input('email'),
                'phone'=> $request->input('phone'),
                'dob'=> $request->input('dob'),
                'acc_type'=> $request->input('acc_type'),
                'currency'=> $request->input('currency'),
                'user_id'=> $user_id,
                'acc_number'=> $acc_number,
                'token'=> $token,
                'acc_status'=> 1,
                'balance'=> 0,
                'user_status'=> "Active",
                'acc_type'=> "Savings",
                'password'=> Hash::make($request->input('password')),
            ]);

            
            $user_id = $request->session()->get('user_id');
            $user = User::where('user_id', $user_id)->first();
            $details = [
                'user_id' => $user_id,
                'token' => $user->token,
                'name' => $user->first_name,
                'acc_number' => $user->acc_number,
                'acc_type' => $user->acc_type,
                'currency' => $user->currency,
            ];
            

            try {
                Mail::to($email)->send(new RegisterMail($details));
                
                return redirect("/")->with('status', ['text'=>'success!,Check your email for account number to Login','type'=>'success']);

            } catch (Throwable $e) {
                
                 return redirect("register")->with('status', ['text'=>'Error!, Your account details could not be sent, please contact admin','type'=>'danger']);
            }    

        }
    }


    public function verifyaccount($user_id, $token)
    {       
        $user = User::where('user_id', $user_id)->first();
        $token2 = $user->token;
        if($token == $token2){
            $post = DB::table('users')
            ->where('user_id', $user_id)
            ->update([
                'acc_status'=> 1,
                'user_status'=> "Active",
            ]);
            return redirect("/")->with('status',['text'=>'Your Email is Verified, Please login','type'=>'success']);
        }else{

            return redirect("/")->with('status',['text'=>'Error!, the token does not match','type'=>'danger']);
        }
 
       
  
        
    }

    

    public function forgot_password(Request $request)
    {
        $title = "Forgot Password" . config('global.site_title');

        if ($request->isMethod('POST')) {
            $request->validate([
                'email' => 'required|email',
            ]);
            
            $email = $request->email;

            $login = User::where('email', $email)
                        ->first();
            if ($login) {
                $name = $login->first_name;
                $user_id = $login->user_id;
                $token = $login->token;


                $details = [
                    'user_id' => $user_id,
                    'token' => $token,
                    'name' => $name,
                ];

                try {
                    Mail::to($email)->send(new PasswordMail($details));
                    return redirect("login")->with('status',['text'=>'Please check your email for link to change password','type'=>'success']);

                } catch (Throwable $e) {
                
                    return redirect("login")->with('status',['text'=>'Sorry!, This email does not exit on our system, please register ','type'=>'danger']);
                }
      
            
            }
        }

        if ($request->isMethod('GET')) {
            return view('frontend.forgot-password', compact('title'));
        }
    }

    public function reset_password(Request $request, $user_id, $token)
    {    
        $title = "Reset Password" . config('global.site_title');
        $user = User::where('user_id', $user_id)->first();
        $token2 = $user->token;

        $post = [
                'user_id' => $user_id,
                'token' => $token,
            ];

        if ($request->isMethod('GET')) {

            if($token == $token2){
                return view('frontend.reset-password', compact('title','post'));
            }else{
                return redirect("login")->with('status',['text'=>'Sorry!, There was an error and token does not match, Please contact admin ','type'=>'danger']);
            }
        }

        if ($request->isMethod('POST')) {
            $request->validate([
                'password' => 'required|min:6|confirmed',
            ]);
            
            $user = DB::table('users')
            ->where('user_id', $user_id)
            ->update([
                'password'=> Hash::make($request->input('password')),
            ]);
      
            return redirect("login")->with('status',['text'=>'Your password was successfully updated, Please Login ','type'=>'success']);
        }
       
    }

    public function adminlogin(Request $request)
    {
        $title = "Admin Login" . config('global.site_title');

        if ($request->isMethod('POST')) {
            $request->validate([
                'username' => 'required',
                'password' => 'required|min:4',
            ]);
            
            $username = $request->username;
            $password = $request->password;

            $login = Admin::where('username', $username)
               ->where('password', md5($password))
               ->first();
            if ($login) {
                $admin_id = $login->admin_id;
                $request->session()->put('admin_id', $admin_id);

               return redirect()->action([AdminController::class, 'index']);
            }
      
            return redirect("admin/login")->with('status',['text'=>'Sorry! you enter wrong credentials ','type'=>'danger']);
        }

        if ($request->isMethod('GET')) {
            return view('frontend.admin', compact('title'));
        }
    }

    public function getIp(){
        if(!empty($_SERVER['HTTP_CLIENT_IP'])){
            //ip from share internet
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        }elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
            //ip pass from proxy
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        }else{
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }

    public function email()
    {   
        $title = "Email" . config('global.site_title');
        $details = [
                'amount' => '93244',
                'acc_type'=>'Savings',
                'acc_number' => '03930394',
                'ip' => 'hqn9223',
                'balance' => '093033',
                'name' => "noble",
                'user_id' => "5244",
                'date' => "5-2-44",
                'otp'=>"049403",
                'currency'=>"USD",
            ];
        return view('email.otpMail', compact('title','details'));
    }
}
