@include('frontend.layouts.header')
@include('frontend.layouts.nav')
@include('dashboard.layouts.sidebar')







<div class="col-lg-8 col-md-12 col-sm-12 white-bg">
    <div class="my-properties mb-50">
        <div class="mt-30 text-center">
            <h4>ACCOUNT SECTION</h4>
        </div>

<div class="row">
<!-- Revenue Card -->
<div class="col-lg-6 col-md-6">
  <div class="card info-card revenue-card">

    <div class="card-body">
      <h5 class="card-title">Balance</h5>

      <div class="d-flex align-items-center">
        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
          <i class="fa fa-dollar fa-3x"></i>
        </div>
        <div class="ps-3 pl-30">
          <h6> N{{ number_format($user->balance, 2, '.', ',') }}</h6>
          

        </div>
      </div>
    </div>

  </div>
</div><!-- End Revenue Card -->

<!-- Revenue Card -->
<div class="col-lg-6 col-md-6">
  <div class="card info-card revenue-card">

    <div class="card-body">
      <h5 class="card-title">Last Withdrawal</h5>

      <div class="d-flex align-items-center">
        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
          <i class="fa fa-dollar fa-3x"></i>
        </div>
        <div class="ps-3 pl-30">
            @if(!empty ($last_withdraw->amount))
                <h6> N{{ number_format($last_withdraw->amount, 2, '.', ',') }}</h6>
            @else
                <h6> N0.00</h6>
            @endif
          

        </div>
      </div>
    </div>

  </div>
</div><!-- End Revenue Card -->
</div> 


<div class="container">
    <div class="mt-30 text-center">
        <hr>
        <h4>Request Withdrawal</h4>
    </div>
    <p>
        @if(session('status'))
            <div class="alert alert-{{session('status')['type']}}">
                {{session('status')['text']}}
            </div>
        @endif
    </p>
    <form action="/user/account" method="POST">
        @csrf
    <div class="row">
        
        <div class="col-lg-8 col-md-6">
            <div class="form-group">
                <label>Enter Amount</label>
                @if ($errors->has('amount'))
                    <span class="text-danger">{{ $errors->first('amount') }}</span>
                @endif
                <input type="number" name="amount" class="form-control" placeholder="Enter Amount" required max="{{ $user->balance }}" value="{{ $user->balance }}">
            </div>
        </div>
        <div class="col-lg-4 col-md-6">
            <div class="form-group">
                <label></label>
                <button type="submit" class="btn btn-4 btn-block">SUBMIT</button>
            </div>
        </div>
    
    </div>
    </form>
</div>

<div class="container">
    <div class="mt-30 text-center">
        <hr>
        <h4>Withdrawal History</h4>
    </div>
    <table class="manage-table">
        <thead>
        <tr>
            <th><strong>Amount</strong></th>
            <th><strong>Date</strong></th>
            
            <th><strong>Status</strong></th>
        </tr>
        </thead>
        <tbody class="responsive-table">
        @foreach ( $pay as $row )
        <tr>
            <td>
                N{{ number_format($row->amount, 2, '.', ',') }}
            </td>
            <td>{{ $row->created_at->format('j F Y');  }}</td>
            @if($row->payment_status =="Pending" )
            <td><span class="text-danger">Pending</span></td>
            @else
            <td><span class="text-success">Paid</span></td>
            @endif
        </tr>
        @endforeach
    </tbody>
</table>
</div>

<div class="pagination-box text-center mt-50">
    <nav aria-label="Page navigation example">
        <ul class="pagination">
            {!! $pay->links() !!}
        </ul>
    </nav>
</div>




    </div>

   
</div>
</div>
</div>
</div>
<!-- User page end -->





@include('frontend.layouts.footer')