@include('frontend.layouts.header')
@include('frontend.layouts.nav')






<!-- Sub banner start -->
<div class="sub-banner">
    <div class="container">
        <div class="breadcrumb-area">
            <h1>{{ $post->prop_title }}</h1>
            <ul class="breadcrumbs">
                <li><a href="/">Home</a></li>
                <li class="active">Property Detail</li>
            </ul>
        </div>
    </div>
</div>
<!-- Sub banner end -->


<!-- User page start -->
<div class="user-page submit-property content-area-7">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
           
                @if(session('status'))
                    <div class="alert alert-{{session('status')['type']}}">
                        {{session('status')['text']}}
                    </div>
                @endif
                <div class="search-area contact-2">
                    <div class="search-area-inner">
                        <div class="search-contents ">
                            <form method="POST" action="/user/add-buyer/{{ $post->prop_id }}">
                                @csrf
                                <h3 class="heading-3">Property Information</h3>
                                <div class="row mb-30">
                                    <div class="col-lg-8 col-md-6">
                                        <div class="form-group">
                                            <label>Property Title</label>
                                            <input type="text" name="property-title" class="form-control" placeholder="Property Title" value="{{ $post->prop_title }}" readonly>
                                        </div>
                                    </div>
                                   
                                    <div class="col-lg-4 col-md-6">
                                        <div class="form-group">
                                            <label>Price</label>
                                            <input type="text" name="price" class="form-control" placeholder="Price" value="N{{ number_format($post->prop_price, 2, '.', ',') }}" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-6">
                                        <div class="form-group">
                                            <label>Area/Location</label>
                                            <input type="text" name="price" class="form-control" placeholder="SqFt" value="{{ $post->prop_address }}" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-6">
                                        <div class="form-group">
                                            <label>Property Type</label>
                                            <input type="text" name="price" class="form-control" placeholder="" value="{{ $post->prop_category }}" readonly>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-6">
                                        <div class="form-group">
                                            <label>Status</label>
                                           @if($post->prop_status== 1)
                                                <p><span class="prop_status">Not Sold</span></p>
                                           @else
                                                <p><span class="prop_status">Sold</span></p>
                                           @endif
                                        </div>
                                    </div>
                                </div>
                                <h3 class="heading-3">Property Gallery</h3>
                                <div class="row mb-45">
                                    <div class="col-lg-12">
                                        <div class="row">
                                            <div class="col-lg-3">
                                                <img src="{{ asset('uploads/'.$post->prop_picture) }}" class="d-block w-100" >
                                            </div>
                                            @foreach ( $image as $pix )
                                            <div class="col-lg-3">
                                                <img src="{{ asset('uploads/images/'.$pix->image) }}"  class="d-block w-100" alt="...">
                                            </div>
                                            @endforeach

                                        </div>
                                    </div>
                                </div>
                                <h3 class="heading-3">Client Information</h3>
                                <div class="row mb-30">
                                    <div class="col-lg-4 col-md-6">
                                        <div class="form-group">
                                            <label>First Name</label>
                                            @if ($errors->has('first_name'))
                                                <span class="text-danger">{{ $errors->first('first_name') }}</span>
                                            @endif
                                            <input type="text" name="first_name" class="form-control" placeholder="First Name" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-6">
                                        <div class="form-group">
                                            <label>Last Name</label>
                                            @if ($errors->has('last_name'))
                                                <span class="text-danger">{{ $errors->first('last_name') }}</span>
                                            @endif
                                            <input type="text" name="last_name" class="form-control" placeholder="Last Name" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-6">
                                        <div class="form-group">
                                            <label>Phone</label>
                                            @if ($errors->has('phone'))
                                                <span class="text-danger">{{ $errors->first('phone') }}</span>
                                            @endif
                                            <input type="text" name="phone" class="form-control" placeholder="Phone Number" required>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <label>Email Address</label>
                                            @if ($errors->has('email'))
                                                <span class="text-danger">{{ $errors->first('email') }}</span>
                                            @endif
                                            <input type="email" name="email" class="form-control" placeholder="Email Address" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <label> Contact Address</label>
                                            @if ($errors->has('address'))
                                                <span class="text-danger">{{ $errors->first('address') }}</span>
                                            @endif
                                            <input type="text" name="address" class="form-control" placeholder="Contact Address" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <label>City</label>
                                            @if ($errors->has('city'))
                                                <span class="text-danger">{{ $errors->first('city') }}</span>
                                            @endif
                                            <input type="text" name="city" class="form-control" placeholder="City" required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <label>State</label>
                                            @if ($errors->has('state'))
                                                <span class="text-danger">{{ $errors->first('state') }}</span>
                                            @endif
                                            <input type="text" name="state" class="form-control" placeholder="State" required>
                                    </div>
                                </div>
                                <div class="mt-50"><hr></div>
                                
                                <div class="row mb-30 mt-50">
                                    <h3 class="heading-3">Payment Information</h3>
                                    <div class="col-lg-12">
                                        
                                    </div>
                                    <div class="col-lg-4 col-md-4">
                                        <div class="form-group">
                                            <label>Down Payment 40% of Price</label>
                                            @if ($errors->has('down_payment'))
                                                <span class="text-danger">{{ $errors->first('down_payment') }}</span>
                                            @endif
                                            <?php $price = $post->prop_price * 0.4;  ?>
                                            <input type="number" name="down_payment" class="form-control" placeholder="" min="{{ $price }}" value="{{ $price }}">
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-4">
                                        <div class="form-group">
                                            <label>Payment Structure</label>
                                            @if ($errors->has('payment_structure'))
                                                <span class="text-danger">{{ $errors->first('payment_structure') }}</span>
                                            @endif
                                            <select class="selectpicker search-fields" name="payment_structure">
                                                <option>0-1 Year</option>
                                                <option>0-2 Years</option>
                                                <option>0-3 Years</option>
                                                <option>0-4 Years</option>
                                                <option>0-5 Years</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-4">
                                        <div class="form-group">
                                            <label>Monthly Payment</label>
                                            @if ($errors->has('monthly_payment'))
                                                <span class="text-danger">{{ $errors->first('monthly_payment') }}</span>
                                            @endif
                                            <input type="text" name="monthly_payment" class="form-control" placeholder="Monthly Payment" required>
                                        </div>
                                    </div>
                                </div>
                           
                         <div class="col-lg-12 text-center">
                            <input type="hidden" name="user_id" value="{{ $user->user_id }}">
                            <input type="hidden" name="prop_id" value="{{ $post->prop_id }}">
                            
                            <button type="submit" class="btn btn-4 btn-block">SUBMIT</button>
                        </div>       
                          
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
</div>
<!-- User page end -->





@include('frontend.layouts.footer')