@include('dashboard.layouts.header')
@include('dashboard.layouts.nav')



<!-- content @s -->
<div class="nk-content nk-content-lg nk-content-fluid">
    <div class="container-xl wide-lg">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head text-center">
                    <div class="nk-block-head-content">
                        <div class="nk-block-head-sub"><span>Make Payment</span></div>
                        <div class="nk-block-head-content">
                            <p>
                                <div class="alert alert-{{session('status-msg')['type']}}">
                                    {{session('status-msg')['text']}}
                                </div>
                            </p>
                            <h2 class="nk-block-title fw-normal">Invoice</h2>
                            <div class="nk-block-des">
                                <p>Please pay  <strong>{{ round($btcprice, 8) }}  BTC</strong> to address: <span id="address"><strong><?php echo $address; ?></strong></span></p>
                            </div>
                        </div>
                    </div>
                </div><!-- nk-block -->

                <div class="row justify-content text-center">
                    <?php
                    // QR code generation using google apis
                    $cht = "qr";
                    $chs = "300x300";
                    $chl = $address;
                    $choe = "UTF-8";

                    $qrcode = 'https://chart.googleapis.com/chart?cht=' . $cht . '&chs=' . $chs . '&chl=' . $chl . '&choe=' . $choe;
                    ?>
                    <div class="col-md-12 d-flex justify-content-center">
                        <img src="<?php echo $qrcode ?>" alt="My QR code" style="width:250px;">
                    </div>
                    
                    
                    <div class="col-md-12 mt-5 d-flex justify-content-center">Status: 
                        <div class="alert alert-{{session('status-msg')['type']}}">
                            {{session('status-msg')['text']}}
                        </div>
                    </div>
              
                    <br><div class="mb-3"></div>
                    <p> <h4 style="width:100%;margin-top: 20px;">What you're paying for:</h4> <h2 style="width:100%;margin-top: 20px;"> <?= $plan_details['plan'] ?> Plan at $<?= $price ?></h2>
                    </p>
                    @php if($status=="2"){ @endphp
                    <div class="nk-iv-wg4-sub text-center bg-lighter">

                        <a href="/user/index" class="btn btn-lg btn-primary ttu">Proceed to Investment Details</a>
                        
                    </div><!-- .nk-iv-wg4-sub -->
                    @php } @endphp
                
                </div>
              
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

<script>
        var status = <?php echo $statusval; ?>
        
        // Create socket variables
        if(status < 2 && status != -2){
        var addr =  document.getElementById("address").innerHTML;
        var wsuri2 = "wss://www.blockonomics.co/payment/"+ addr;
        // Create socket and monitor
        var socket = new WebSocket(wsuri2, "protocolOne")
            socket.onmessage = function(event){
                console.log(event.data);
                response = JSON.parse(event.data);
                //Refresh page if payment moved up one status
                if (response.status > status)
                  setTimeout(function(){ window.location=window.location }, 1000);
            }
        }
        
    </script>
    <script>
    window.setInterval('refresh()', 10000);     // Call a function every 10000 milliseconds (OR 10 seconds).

    // Refresh or reload page.
    function refresh() {
        window .location.reload();
    }
</script>

@include('dashboard.layouts.footer')