@include('dashboard.layouts.header')
@include('dashboard.layouts.nav')
<script src="{{ asset('backend/js/jquery.min.js') }}"></script>


<!-- content @s -->
<div class="nk-content nk-content-lg nk-content-fluid pt-100">
    <div class="container-xl wide-lg">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head">
                    <div class="nk-block-head-content">
                        <div class="nk-block-head-sub"><a href="html/invest/schemes.html" class="text-soft back-to"><em class="icon ni ni-arrow-left"> </em><span>My Investment</span></a></div>
                        <div class="nk-block-between-md g-4">
                            <div class="nk-block-head-content">
                                <h2 class="nk-block-title fw-normal">{{ $user->plan }} - Daily {{ $user->rate }}% for 30 Days</h2>
                                <div class="nk-block-des">
                                    <p>INV-{{ $user->plan_id }} <span class="badge badge-outline badge-primary">Running</span></p>
                                </div>
                            </div>
                            <div class="nk-block-head-content">
                                <ul class="nk-block-tools gx-3">
                                    <li><a href="/user/withdraw" class="btn btn-primary"><span>Withdraw</span> <em class="icon ni ni-arrow-long-right d-none d-sm-inline-block"></em></a></li>
                                    <li><a href="/user/plan" class="btn btn-white btn-light"><span>Invest More</span> <em class="icon ni ni-arrow-long-right d-none d-sm-inline-block"></em></a></li>
                                    
                                </ul>
                            </div>
                        </div>
                    </div>
                </div><!-- .nk-block-head -->
                <div class="nk-block">
                    <div class="card card-bordered">
                        <div class="card-inner">
                            <div class="row gy-gs">
                                <div class="col-md-6">
                                    <div class="nk-iv-wg3">
                                        <div class="nk-iv-wg3-group flex-lg-nowrap gx-4">
                                            <div class="nk-iv-wg3-sub">
                                                @php if($total_invest==0){$total_invest=0;}  @endphp
                                                <div class="nk-iv-wg3-amount">
                                                    <div class="number">$ {{ number_format($total_invest, 2, '.', ',') }}</div>
                                                </div>
                                                <div class="nk-iv-wg3-subtitle">Invested Amount</div>
                                            </div>
                                            <div class="nk-iv-wg3-sub">
                                                <span class="nk-iv-wg3-plus text-soft"><em class="icon ni ni-plus"></em></span>
                                                <div class="nk-iv-wg3-amount">
                                                    <div class="number">$ {{ number_format($user->profit, 2, '.', ',') }}  <span class="number-up">{{ $user->rate }} %</span></div>
                                                </div>
                                                <div class="nk-iv-wg3-subtitle">Profit Earned</div>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- .col -->
                                <div class="col-md-6 col-lg-4 offset-lg-2">
                                    <div class="nk-iv-wg3 pl-md-3">
                                        <div class="nk-iv-wg3-group flex-lg-nowrap gx-4">
                                            <div class="nk-iv-wg3-sub">
                                                <div class="nk-iv-wg3-amount">
                                                    <div class="number">$ {{ number_format($total_invest + $user->profit, 2, '.', ',') }}  
                                                </div>
                                                <div class="nk-iv-wg3-subtitle">Total Return</div>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- .col -->
                            </div><!-- .row -->
                        </div>
                        <div id="schemeDetails" class="nk-iv-scheme-details">
                            <ul class="nk-iv-wg3-list">
                                <li>
                                    <div class="sub-text">Term</div>
                                    <div class="lead-text">30 Days</div>
                                </li>
                             
                                <li>
                                    <div class="sub-text">Daily interest</div>
                                    <div class="lead-text">{{ $user->rate }}%</div>
                                </li>
                            </ul><!-- .nk-iv-wg3-list -->
                            <ul class="nk-iv-wg3-list">
                                <li>
                                    <div class="sub-text">Ordered date</div>
                                     
                                    <div class="lead-text"></div>
                                </li>
                              
                                <li>
                                    <div class="sub-text">Profit <small>(Bonus include)</small></div>
                                    <div class="lead-text"><span class="currency currency-usd">USD</span> {{ number_format($user->profit + $user->bonus + $user->referal_bonus, 2, '.', ',') }} </div>
                                </li>
                            </ul><!-- .nk-iv-wg3-list -->
                            <ul class="nk-iv-wg3-list">
                                <li>
                                    <div class="sub-text">Captial invested</div>
                                    <div class="lead-text"><span class="currency currency-usd">USD</span>  {{ number_format($total_invest, 2, '.', ',') }}</div>
                                </li>
                            
                                <li>
                                    <div class="sub-text">Total return</div>
                                    <div class="lead-text"><span class="currency currency-usd">USD</span>  {{ number_format($total_invest + $user->profit, 2, '.', ',') }}</div>
                                </li>
                            </ul><!-- .nk-iv-wg3-list -->
                        </div><!-- .nk-iv-scheme-details -->
                    </div>
                </div><!-- .nk-block -->
              
                <div class="nk-block nk-block-lg mt-50">
                    <div class="nk-block-head">
                        <h5 class="nk-block-title">Transactions</h5>
                    </div>
                    <div class="card card-bordered">
                        <table class="table table-iv-tnx">
                            <thead class="thead-light">
                                <tr>
                                    <th class="tb-col-type"><span class="overline-title">Type</span></th>
                                    <th class="tb-col-date"><span class="overline-title">Date</span></th>
                                    <th class="tb-col-time tb-col-end"><span class="overline-title">Amount</span></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ( $profit as $row )
                                <tr>
                                    <td class="tb-col-type"><span class="sub-text">Profit</span></td>
                                    <td class="tb-col-date"><span class="sub-text">{{ $row->created_at->format('j F Y');  }}</span></td>
                                    <td class="tb-col-time tb-col-end"><span class="lead-text">+ ${{ number_format($row->amount, 2, '.', ',') }}</span></td>
                                </tr>
                                @endforeach
                              
                            </tbody>
                        </table>
                    </div><!-- .card -->
                </div><!-- .nk-block -->
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

@include('dashboard.layouts.footer')