@include('dashboard.layouts.header')
@include('dashboard.layouts.sidebar')
@include('dashboard.layouts.nav')


<!-- content @s -->
<div class="nk-content nk-content-fluid">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            
            <div class="nk-block nk-block-lg">
                <div class="nk-block-head">
                    <div class="nk-block-head-content">
                        <h4 class="title nk-block-title">{{ config('global.site_name') }} Consumer Loan Application</h4>
                        <div class="nk-block-des">
                            <p>You can monitor your account activity 24 hours a day. Also You can apply for loans of any amount here.</p>
                        </div>
                    </div>
                </div>
                <div class="card card-bordered">
                    <div class="card-inner">
                        <div class="card-head">
                            <h5 class="card-title">Loan Application</h5>
                        </div>
                        <form action="/user/loan" method="POST">
                            @csrf
                            <div class="row g-4">
                                <div class="col-lg-12">
                                    @if(session('status'))
                                        <div class="alert alert-{{session('status')['type']}}">
                                            {{session('status')['text']}}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="default-06">Loan Type <span class="text-danger">*</span></label>
                                        <div class="form-control-wrap ">
                                            <div class="form-control-select">
                                                <select class="form-control" id="default-06" required name="loan_type">
                                                    <option value="">Please Select Loan Type</option>
                                                    <option value="Personal Loan">Personal Loan</option>
                                                    <option value="Asset Acquisition">Asset Acquisition</option>
                                                    <option value="SME Loan">SME Loan</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="email-address-1">Amount ({{ $user->currency }})<span class="text-danger">*</span></label>
                                        <div class="form-control-wrap">
                                            <input type="number" class="form-control" name="amount" required value="{{ old('amount') }}">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="default-06">Tenure <span class="text-danger">*</span></label>
                                        <div class="form-control-wrap ">
                                            <div class="form-control-select">
                                                <select class="form-control" id="default-06" required name="tenure">
                                                    <option value="">Please Select Loan Tenure</option>
                                                    <option value="3 Months">3 Months</option>
                                                    <option value="6 Months">6 Months</option>
                                                    <option value="12 Months">12 Months</option>
                                                    <option value="24 Months">24 Months</option>
                                                    <option value="36 Months">36 Months</option>
                                                    <option value="48 Months">48 Months</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="default-06">Payment Plan <span class="text-danger">*</span></label>
                                        <div class="form-control-wrap ">
                                            <div class="form-control-select">
                                                <select class="form-control" id="default-06" required name="payment_plan">
                                                    <option value="">Please Select payment plan</option>
                                                    <option value="Monthly">Monthly</option>
                                                    <option value="Quarterly">Quarterly</option>
                                                    <option value="Semi-Annually">Semi-Annually</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="phone-no-1">Reason for Loan <span class="text-danger">*</span></label>
                                        <div class="form-control-wrap">
                                            <textarea class="form-control" name="reason" required>{{ old('reason') }}</textarea>
                                            
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label"></label>
                                        <ul class="custom-control-group g-3 align-center">
                                            <li>
                                                <div class="custom-control custom-control-sm custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" id="com-email" required>
                                                    <label class="custom-control-label" for="com-email">Agree with terms and conditions</label>
                                                </div>
                                            </li>
                                            
                                        </ul>
                                    </div>
                                </div>
                                
                              
                                <div class="col-12">
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-lg btn-primary">Submit</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div><!-- .nk-block -->

        </div>
    </div>
</div>
<!-- content @e -->





@include('dashboard.layouts.footer')