<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PageController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::any('/', [PageController::class, 'index']);
Route::any('/login', [PageController::class, 'index']);
Route::any('/register', [PageController::class, 'register']);
Route::any('/authenticate', [PageController::class, 'authenticate']);
Route::get('/account-status', [PageController::class, 'account_status']);
Route::any('/resend-otp', [PageController::class, 'resend_otp']);
Route::get('/verifyaccount/{id}/{token}', [PageController::class, 'verifyaccount']);
Route::any('/forgot-password', [PageController::class, 'forgot_password']);
Route::any('/reset-password/{id}/{token}', [PageController::class, 'reset_password']);
Route::any('/admin/login', [PageController::class, 'adminlogin']);
Route::any('/email', [PageController::class, 'email']);


//User Dashboard Section
Route::get('/user/index', [UserController::class, 'index'])->name('user.index')->middleware('usersession');
Route::get('/user/transactions', [UserController::class, 'transactions'])->middleware('usersession');
Route::any('/user/local-transfer', [UserController::class, 'local_transfer'])->middleware('usersession');
Route::any('/user/wire-transfer', [UserController::class, 'wire_transfer'])->middleware('usersession');
Route::any('/user/confirm-transfer', [UserController::class, 'confirm_transfer'])->middleware('usersession');
Route::any('/user/send-otp', [UserController::class, 'send_otp'])->middleware('usersession');
Route::any('/user/confirm-otp', [UserController::class, 'confirm_otp'])->middleware('usersession');
Route::any('/user/transfer-status', [UserController::class, 'transfer_status'])->middleware('usersession');
Route::any('/user/payments', [UserController::class, 'payments'])->middleware('usersession');
Route::any('/user/loan', [UserController::class, 'loan'])->middleware('usersession');
Route::any('/user/profile', [UserController::class, 'profile'])->middleware('usersession');
Route::any('/user/profile-picture', [UserController::class, 'profile_picture'])->middleware('usersession');
Route::any('/user/change-password', [UserController::class, 'change_password'])->middleware('usersession');
Route::any('/user/feedback', [UserController::class, 'feedback'])->middleware('usersession');
Route::get('/user/logout', [UserController::class, 'logout'])->middleware('usersession');

Route::any('/site/{mode}', [UserController::class, 'site_mode'])->middleware('usersession');


//Admin Index
Route::get('/admin/index', [AdminController::class, 'index'])->middleware('adminsession');
Route::any('/admin/new-user', [AdminController::class, 'new_user'])->middleware('adminsession');
Route::get('/admin/users', [AdminController::class, 'users'])->middleware('adminsession');
Route::any('/admin/change-status/{id}', [AdminController::class, 'change_status'])->middleware('adminsession');
Route::any('/admin/view-user/{id}', [AdminController::class, 'view_user'])->middleware('adminsession');
Route::any('/admin/update-picture/{id}', [AdminController::class, 'update_picture'])->middleware('adminsession');
Route::any('/admin/edit-user/{id}', [AdminController::class, 'edit_user'])->middleware('adminsession');
Route::any('/admin/delete-user/{id}', [AdminController::class, 'delete_user'])->middleware('adminsession');
Route::any('/admin/new-trans/{id}', [AdminController::class, 'new_trans'])->middleware('adminsession');
Route::any('/admin/delete-trans/{id}/{userid}', [AdminController::class, 'delete_trans'])->middleware('adminsession');
Route::any('/admin/add-profit/{id}', [AdminController::class, 'add_profit'])->middleware('adminsession');
Route::any('/admin/new-loan/{id}', [AdminController::class, 'new_loan'])->middleware('adminsession');
Route::any('/admin/repay-loan/{id}', [AdminController::class, 'repay_loan'])->middleware('adminsession');
Route::get('/admin/withdraw', [AdminController::class, 'withdraw'])->middleware('adminsession');
Route::get('/admin/pending-payment', [AdminController::class, 'pending_payment'])->middleware('adminsession');
Route::any('/admin/mark-paid/{id}', [AdminController::class, 'mark_paid'])->middleware('adminsession');
Route::any('/admin/site-settings', [AdminController::class, 'settings'])->middleware('adminsession');
Route::any('/admin/change-password', [AdminController::class, 'password'])->middleware('adminsession');
Route::get('/admin/logout', [AdminController::class, 'logout'])->middleware('adminsession');