<?php echo $__env->make('dashboard.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('dashboard.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('dashboard.layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<!-- content @s -->
<div class="nk-content nk-content-fluid">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            
            <div class="nk-block nk-block-lg">
                <div class="nk-block-head">
                    <div class="nk-block-head-content">
                        <h4 class="title nk-block-title"><?php echo e(config('global.site_name')); ?> Bills Payment</h4>
                        <div class="nk-block-des">
                            <p>You can monitor your account activity 24 hours a day.</p>
                        </div>
                    </div>
                </div>
                <div class="card card-bordered">
                    <div class="card-inner">
                        <div class="card-head">
                            <h5 class="card-title">Bills Payment</h5>
                        </div>
                        <form action="/user/payments" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row g-4">
                                <div class="col-lg-12">
                                    <?php if(session('status')): ?>
                                        <div class="alert alert-<?php echo e(session('status')['type']); ?>">
                                            <?php echo e(session('status')['text']); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="default-06">Select Bill Type <span class="text-danger">*</span></label>
                                        <div class="form-control-wrap ">
                                            <div class="form-control-select">
                                                <select class="form-control" id="default-06" required name="category">
                                                    <option value="">Please Select Bill Type</option>
                                                    <option>Donation</option>
                                                    <option>Airline</option>
                                                    <option>Hotel</option>
                                                    <option>Insurance</option>
                                                    <option>Fashion</option>
                                                    <option>Internet Services</option>
                                                    <option>Gaming/Lottery</option>
                                                    <option>Shipping</option>
                                                    <option>Taxes/ Levies</option>
                                                    <option>Transportation</option>
                                                    <option>Microfinance</option>
                                                    <option>Schools</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="email-address-1">Biller<span class="text-danger">*</span></label>
                                        <div class="form-control-wrap">
                                            <input type="text" class="form-control" name="biller" required value="<?php echo e(old('biller')); ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="email-address-1">Amount (<?php echo e($user->currency); ?>)<span class="text-danger">*</span></label>
                                        <div class="form-control-wrap">
                                            <input type="number" class="form-control" name="amount" required value="<?php echo e(old('amount')); ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="default-06">One Time Transfer? <span class="text-danger">*</span></label>
                                        <div class="form-control-wrap ">
                                            <div class="form-control-select">
                                                <select class="form-control" id="default-06" required name="transfer_type">
                                                    <option>One Time?</option>
                                                    <option>Repeating</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label"></label>
                                        <ul class="custom-control-group g-3 align-center">
                                            <li>
                                                <div class="custom-control custom-control-sm custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" id="com-email" required>
                                                    <label class="custom-control-label" for="com-email">Agree with terms and conditions</label>
                                                </div>
                                            </li>
                                            
                                        </ul>
                                    </div>
                                </div>
                                
                              
                                <div class="col-12">
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-lg btn-primary">Submit</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div><!-- .nk-block -->

        </div>
    </div>
</div>
<!-- content @e -->





<?php echo $__env->make('dashboard.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/www/laravel/bankdash/resources/views/dashboard/payments.blade.php ENDPATH**/ ?>